#include "commonheaders.h"
#include "cls-window.h"
#include "cls-windraw.h"

ScrollBox::ScrollBox(short xLocation, short yLocation, short winWidth, bool dropdown, short mode, short *refval, short lowval, short highval, short increment) {
    refmode = mode;
    xPos = xLocation;
    yPos = yLocation;
    width = winWidth;
    ref = refval;
    optList = NULL;
    
    low = lowval;
    high = highval;
    inc = increment;
    drop = false;
    right = false;
    left = false;
    droppress = false;
    input = (char *)calloc((width / 8), sizeof(char));
    waitingforinput = false;
    funct = NULL;
    functionflag = false;
}

bool ScrollBox::ReplaceItem(char *olditem, char *newitem) {
    if(optList != NULL) {
        short i = low, itemgood = -1, itembad = -1;
        while(i < high - 1 && optList[i] != NULL) {
            if(strcmp(newitem, optList[i]) == 0) {
                itemgood = i;
            }
            if(strcmp(olditem, optList[i]) == 0) {
                itembad = i;
            }
            i += inc;
        }
        if(itembad == -1 && itemgood != -1) {
            optList[itemgood] = (char *)qualloc(optList[itemgood], sizeof(char) * strlen(newitem) + 1);
            Init_String(optList[itemgood], newitem, 0);
            return true;
        }
    }
    return false;
}
bool ScrollBox::AddItem(char *newitem) {
    if(optList == NULL) {
        high += inc;
        optList = (char **)qualloc(sizeof(char *) * ((high - low) / inc + 1));
        optList[(high - low) / inc] = (char *)qualloc(sizeof(char) * strlen(newitem) + 1);
    	Init_String(optList[(high - low) / inc], newitem, 0);
        optList[(high - low) / inc + 1] = NULL;
        return true;
    } else {
        high += inc;
        optList = (char **)realloc(optList, sizeof(char *) * ((high - low) / inc + 1));
        optList[(high - low) / inc] = (char *)qualloc(sizeof(char) * strlen(newitem) + 1);
    	Init_String(optList[(high - low) / inc], newitem, 0);
        optList[(high - low) / inc + 1] = NULL;
        return true;
    }
    return false;
}
bool ScrollBox::EraseItem(short itemnum) {
    for(int i = itemnum; i < (high - low) / inc; i ++)
    {
        //Copy list[i+1] into list[i].
    	optList[i] = (char *)qualloc(optList[i], sizeof(char) * strlen(optList[i + 1]) + 1);
    	strcpy(optList[i], optList[i + 1]);
    }
    if((high - low) / inc >= 0)
    {
        //Erase the last component in list
        high -= inc;
        free(optList[(high - low) / inc + 1]);
        optList[(high - low) / inc + 1] = NULL;
        if((high - low) / inc >= 0) 
            optList = (char **)qualloc(optList, sizeof(char *) * ((high - low) / inc + 1));
        else
        {
            free(optList);
            optList = NULL;
        }
    }
    return true;
}

bool ScrollBox::ItemUp(short itemnum) {
    if(itemnum > 0 && itemnum < high + 1) {
        char * tempstr;
        short len1, len2;
        len1 = strlen(optList[itemnum]);
        len2 = strlen(optList[itemnum - 1]);
        if(len1 > len2) {
            tempstr = (char *)qualloc(sizeof(char) * len1);
            optList[itemnum - 1] = (char *)qualloc(optList[itemnum - 1], sizeof(char) * len1);
            optList[itemnum - 1][len2] = '\0';
            strcpy(tempstr, optList[itemnum - 1]);
            strcpy(optList[itemnum - 1], optList[itemnum]);
            strcpy(optList[itemnum], tempstr);
            optList[itemnum] = (char *)qualloc(optList[itemnum], sizeof(char) * len2);
            optList[itemnum][len2] = '\0';
        } else if (len1 < len2) {
            tempstr = (char *)qualloc(sizeof(char) * len2);
            optList[itemnum] = (char *)qualloc(optList[itemnum], sizeof(char) * len2);
            optList[itemnum][len1] = '\0';
            strcpy(tempstr, optList[itemnum - 1]);
            strcpy(optList[itemnum - 1], optList[itemnum]);
            strcpy(optList[itemnum], tempstr);
            optList[itemnum - 1] = (char *)qualloc(optList[itemnum - 1], sizeof(char) * len1);
            optList[itemnum - 1][len1] = '\0';
        } else {
            tempstr = (char *)qualloc(sizeof(char) * len1);
            strcpy(tempstr, optList[itemnum - 1]);
            strcpy(optList[itemnum - 1], optList[itemnum]);
            strcpy(optList[itemnum], tempstr);
        }
        return true;
    }
    return false;
}
bool ScrollBox::ItemDn(short itemnum) {
    if(itemnum >= 0 && itemnum < high) {
        char * tempstr;
        short len1, len2;
        len1 = strlen(optList[itemnum]);
        len2 = strlen(optList[itemnum + 1]);
        if(len1 > len2) {
            tempstr = (char *)qualloc(sizeof(char) * len1);
            optList[itemnum + 1] = (char *)qualloc(optList[itemnum + 1], sizeof(char) * len1);
            optList[itemnum + 1][len2] = '\0';
            strcpy(tempstr, optList[itemnum + 1]);
            strcpy(optList[itemnum + 1], optList[itemnum]);
            strcpy(optList[itemnum], tempstr);
            optList[itemnum] = (char *)qualloc(optList[itemnum], sizeof(char) * len2);
            optList[itemnum][len2] = '\0';
        } else if (len1 < len2) {
            tempstr = (char *)qualloc(sizeof(char) * len2);
            optList[itemnum] = (char *)qualloc(optList[itemnum], sizeof(char) * len2);
            optList[itemnum][len1] = '\0';
            strcpy(tempstr, optList[itemnum + 1]);
            strcpy(optList[itemnum + 1], optList[itemnum]);
            strcpy(optList[itemnum], tempstr);
            optList[itemnum + 1] = (char *)qualloc(optList[itemnum + 1], sizeof(char) * len1);
            optList[itemnum + 1][len1] = '\0';
        } else {
            tempstr = (char *)qualloc(sizeof(char) * len1);
            strcpy(tempstr, optList[itemnum + 1]);
            strcpy(optList[itemnum + 1], optList[itemnum]);
            strcpy(optList[itemnum], tempstr);
        }
        return true;
    }
    return false;
}
bool ScrollBox::ModInt(short lowval, short highval, short increment) {
    if(refmode == 0) {
		printf("SC %i, %i, %i", lowval, highval, increment);
        low = lowval;
        high = highval;
        inc = increment;
    }
    return true;
}
void ScrollBox::SetFunction(void (*function)(void)) {
    funct = function;
    functionflag = true;
}
bool ScrollBox::Check(short xLocation, short yLocation) {
    bool ret = false;
    if(waitingforinput) {
        ret = true;
        if(strlen(input) < (width / 8) - 1) {
            GetInputFromBuffer(input, strlen(input), refmode);
        } else {
            GetInputFromBuffer(input, strlen(input) - 1, refmode);
        }
        if(refmode == 0) {
            short inval;
            inval = atoi(input);
            if(inval < low) {
                *ref = low;
                if(functionflag == true) funct();
            } else if(inval > high) {
                *ref = high;
                if(functionflag == true) funct();
            } else {
                *ref = inval;
                if(functionflag == true) funct();
            }
        } else {
            for(short i = low; i < high; i++) {
                if(!strcasecmp(input, optList[i]) && *ref != i) {
                    *ref = i;
                    if(functionflag == true) funct();
                }
            }
        }
        if((mouse_b & 1) || (mouse_b & 2) || key[KEY_ENTER]) {
            clear_keybuf();
            waitingforinput = false;
        }
    }
    if(mouse_inarea(xPos + xLocation, yPos + yLocation, 8, 15)) {
        if(mouse_b & 1 && !left) {
            left = true;
            right = false;
            droppress = false;
            if(inc > 0 && ref != NULL) {
                if(*ref > low) {
                    *ref -= inc;
                } else if(*ref == low) {
                    *ref = high;
                }
                if(*ref < low) *ref = low;
                if(functionflag == true) {
                    funct();
                }
            }
        }
    } else if(mouse_inarea(xPos + xLocation + width + 8, yPos + yLocation, 8, 15)) {
        if(mouse_b & 1 && !right) {
            right = true;
            left = false;
            droppress = false;
            if(inc > 0 && ref != NULL) {
                if(*ref < high) {
                    *ref += inc;
                } else if(*ref == high) {
                    *ref = low;
                }
                if(*ref > high) *ref = high;
                if(functionflag == true) {
                    funct();
                }
            }
        }
    } else if(mouse_inarea(xPos + xLocation + 8, yPos + yLocation, width, 15)) {
        if(mouse_b & 1) {
            droppress = false;
            if(!waitingforinput) {
                strclr(input);
                if(refmode == 0) {
                    if(*ref > 0) {
                        itoa(*ref, input,10);
                    } 
                } else if(optList != NULL) {
                    if(optList[*ref] != NULL) {
                        strcpy(input, optList[*ref]);
                    }
                }
                clear_keybuf();
                waitingforinput = true;
                ret = true;
                if(funct != NULL) funct();
            }
        }
    } else if(drop) {
        if(mouse_inarea(xPos + xLocation + width + 16, yPos + yLocation, 16, 16)) {
            if(mouse_b & 1) {
                droppress = true;
                right = false;
                left = false;
            }
        }
    } else {
        left = false;
        right = false;
        droppress = false;
    }
    if(droppress) {
        if(mouse_b & 1) {
            if(yPos + yLocation + 144 <= WIN_HEIGHT) {
                if(!mouse_inarea(xPos + xLocation, yPos + yLocation, width + 32, 144)) {
                    droppress = false;
                }
            } else {
                if(!mouse_inarea(xPos + xLocation, yPos + yLocation - 128, width + 32, 144)) {
                    droppress = false;
                }
            }
        }
    }
    if(!(mouse_b & 1)) {
        left = false;
        right = false;
    }
    if(curflash < 90) {
        curflash ++;
    } else {
        curflash = 0;
    }
    return ret;
}
void ScrollBox::Draw(BITMAP *output, short xLocation, short yLocation) {
    if(!left) {
        draw_sprite(output, ScrollArrow, xPos + xLocation, yPos + yLocation);
    } else {
        draw_sprite(output, ScrollArrowPush, xPos + xLocation, yPos + yLocation);
    }
    text_box(output, xPos + xLocation + 8, yPos + yLocation, width, 16, makecol(64,64,64), NULL);
    if(inc > 0 && ref != NULL && !waitingforinput) {
        if(refmode == 0) {
            textprintf_centre(output, font, xPos + xLocation + 8 + (width / 2) + 2, yPos + yLocation + 8 - 2, makecol(32, 32, 32), "%i", *ref);
            textprintf_centre(output, font, xPos + xLocation + 8 + (width / 2) + 1, yPos + yLocation + 8 - 3, makecol(32, 32, 32), "%i", *ref);
            textprintf_centre(output, font, xPos + xLocation + 8 + (width / 2), yPos + yLocation + 8 - 4, makecol(255, 255, 255), "%i", *ref); 
        } else {
            if(*ref >= low && *ref <= high) {
                if(optList != NULL) {
                    if(optList[*ref] != NULL) {
                        textprintf_centre(output, font, xPos + xLocation + 8 + (width / 2) + 2, yPos + yLocation + 8 - 2, makecol(32, 32, 32), "%s", optList[*ref]);
                        textprintf_centre(output, font, xPos + xLocation + 8 + (width / 2) + 1, yPos + yLocation + 8 - 3, makecol(32, 32, 32), "%s", optList[*ref]);
                        textprintf_centre(output, font, xPos + xLocation + 8 + (width / 2), yPos + yLocation + 8 - 4, makecol(255, 255, 255), "%s", optList[*ref]); 
                    }
                }
            }
        }
    }
    if(waitingforinput) {
        if(input[0] == '\0') {
            if(refmode == 0) {
                textprintf_centre(output, font, xPos + xLocation + 8 + (width / 2) + 2, yPos + yLocation + 8 - 2, makecol(32, 32, 32), "0");
                textprintf_centre(output, font, xPos + xLocation + 8 + (width / 2) + 1, yPos + yLocation + 8 - 3, makecol(32, 32, 32), "0");
                textprintf_centre(output, font, xPos + xLocation + 8 + (width / 2), yPos + yLocation + 8 - 4, makecol(255, 255, 255), "0"); 
            }
            if(curflash < 45) {
                textprintf_centre(output, font, xPos + xLocation + 8 + (width / 2) + 1, yPos + yLocation + 8 - 3, makecol(32, 32, 32), "_");
                textprintf_centre(output, font, xPos + xLocation + 8 + (width / 2), yPos + yLocation + 8 - 4, makecol(255, 255, 255), "_"); 
            }
        } else {
            char addon = '\0';
            if(strlen(input) < (width / 8) - 1) {
                if(curflash < 45) {
                    addon = '_';
                } else {
                    addon = ' ';
                }
            }
            textprintf_centre(output, font, xPos + xLocation + 8 + (width / 2) + 2, yPos + yLocation + 8 - 2, makecol(32, 32, 32), "%s%c", input, addon);
            textprintf_centre(output, font, xPos + xLocation + 8 + (width / 2) + 1, yPos + yLocation + 8 - 3,  makecol(32, 32, 32), "%s%c", input, addon);
            textprintf_centre(output, font, xPos + xLocation + 8 + (width / 2), yPos + yLocation + 8 - 4, makecol(255, 255, 255), "%s%c", input, addon); 
            if(addon != '_' && curflash < 45) {
                textprintf(output, font, xPos + xLocation + 4 + (width / 2) + (strlen(input) - 1) * 8 / 2 + 1, yPos + yLocation + 8 - 3,  makecol(32, 32, 32), "_");
                textprintf(output, font, xPos + xLocation + 4 + (width / 2) + (strlen(input) - 1) * 8 / 2, yPos + yLocation + 8 - 4, makecol(255, 255, 255), "_"); 
            }
        }
                
    }
    if(!right) {
        draw_sprite_h_flip(output, ScrollArrow, xPos + xLocation + width + 8, yPos + yLocation);
    } else {
        draw_sprite_h_flip(output, ScrollArrowPush, xPos + xLocation + width + 8, yPos + yLocation);
    }
    if(drop) {
        draw_sprite(output, ScrollDown, xPos + xLocation + width + 16, yPos + yLocation);
        if(droppress) {
            if(yPos + yLocation + 144 <= WIN_HEIGHT) {
                text_box(output, xPos + xLocation, yPos + yLocation + 16, width + 32, 128, makecol(64,64,64), NULL);
            } else {
                text_box(output, xPos + xLocation, yPos + yLocation - 128, width + 32, 128, makecol(64,64,64), NULL);
            }   
            if(!down) {
                draw_sprite(output, ListDn, xPos + xLocation + width - 10, yPos + yLocation * 10 - 6);
            } else {
                draw_sprite(output, ListDnPush, xPos + xLocation + width - 10, yPos + yLocation * 10 - 6);
            }
            if(!up) {
                draw_sprite(output, ListUp, xPos + xLocation + width - 10, yPos + yLocation);
            } else {
                draw_sprite(output, ListUpPush, xPos + xLocation + width - 10, yPos + yLocation);
            }
        }
    }
}
